#include ".\..\..\Source\inc\GameEngine.h"

typedef struct tagKEY_STATUS
{
	unsigned long pressed;
	unsigned long released;
	unsigned long status;
} KEY_STATUS;

extern "C" void kbd_get_status(KEY_STATUS* ks);

#define		SKEY_2			0x00000010 // ------------------- NO MAPEADOS
#define		SKEY_A2			0x00000020 // ------------------- NO MAPEADOS
#define		SKEY_Y			0x00000040 //BOTON  Y
#define		SKEY_POWER		0x00000080 // BOTON POWER

#define		SKEY_L			0x00000100 // BOTON L
#define		SKEY_B2			0x00000200 // ------------------- NO MAPEADOS 2
#define		SKEY_SELECT		0x00000400 // BOTON SELECT
#define		SKEY_START		0x00000800 // BOTON START

#define		SKEY_X			0x00010000 //BOTON  X
#define     SKEY_C2         0x00020000 // ------------------- NO MAPEADOS
#define		SKEY_RIGHT		0x00040000 //BOTON RIGHT
#define		SKEY_C4			0x00080000 // ------------------- NO MAPEADOS 2

#define		SKEY_UP			0x00100000 //BOTON UP
#define 	SKEY_B 			0x00200000 //BOTON B
#define     SKEY_D3			0x00400000 // ------------------- NO MAPEADOS
#define     SKEY_D4			0x00800000 // ------------------- NO MAPEADOS 2

#define		SKEY_E1			0x01000000 // ------------------- NO MAPEADOS 3
#define		SKEY_E2			0x02000000 // ------------------- NO MAPEADOS 3
#define		SKEY_E3			0x04000000 // ------------------- NO MAPEADOS 3
#define		SKEY_DOWN		0x08000000 //BOTON DOWN

#define		SKEY_LEFT		0x10000000 //BOTON LEFT
#define		SKEY_R			0x20000000 //BOTON R ???
#define     SKEY_F3			0x40000000 // ------------------- NO MAPEADOS
#define		SKEY_A			0x80000000 //BOTON A


extern bool g_bGameRuning ;
extern Char g_FilePath[256];
extern Char g_AppFullName[256];
extern "C" int sys_judge_event(void * fun);
extern "C" char *__to_locale_ansi(wchar_t *);


KEY_STATUS ks;
KEY_STATUS oldks;

extern "C" void onkey( Engine* pEng )
{
	kbd_get_status( &ks );
	
	//SKEY_LEFT
	if( ks.status & SKEY_LEFT ){
		pEng->m_pInput->KeyDown( KEY_LF );
	}else{
		if( oldks.status & SKEY_LEFT ) 
			pEng->m_pInput->KeyUp( KEY_LF );
	}
	//SKEY_RIGHT
	if( ks.status & SKEY_RIGHT ){
		pEng->m_pInput->KeyDown( KEY_RT );
	}else{
		if( oldks.status & SKEY_RIGHT ) 
			pEng->m_pInput->KeyUp( KEY_RT );
	}
	//SKEY_UP
	if( ks.status & SKEY_UP ){
		pEng->m_pInput->KeyDown( KEY_UP );
	}else{
		if( oldks.status & SKEY_UP ) {
			pEng->m_pInput->KeyUp( KEY_UP );
		}
	}
	//SKEY_DOWN
	if( ks.status & SKEY_DOWN ){
		pEng->m_pInput->KeyDown( KEY_DN );
	}else{
		if( oldks.status & SKEY_DOWN ) {
			pEng->m_pInput->KeyUp( KEY_DN );
		}
	}
	
	//SKEY_POWER - POWER
	if( ks.status &  SKEY_POWER){
		pEng->m_pInput->KeyDown( KEY_9 );
	}else{
		if( oldks.status & SKEY_POWER ) 
			pEng->m_pInput->KeyUp( KEY_9 );
	}
	
	//SKEY_A	- A
	if( ks.status & SKEY_A ){
		pEng->m_pInput->KeyDown( KEY_0 );
	}else{
			pEng->m_pInput->KeyUp( KEY_0 );
	}
	//SKEY_B - B
	if( ks.status &  SKEY_B ){
		pEng->m_pInput->KeyDown( KEY_1 );
	}else{
		if( oldks.status & SKEY_B ) 
			pEng->m_pInput->KeyUp( KEY_1 );
	}

	//SKEY_Y - X
	if( ks.status & SKEY_Y ){
		 pEng->m_pInput->KeyDown( KEY_3 );
	}else{
		 	pEng->m_pInput->KeyUp( KEY_3 );
	}
	//SKEY_X  - Y
	if( ks.status &  SKEY_X){
		pEng->m_pInput->KeyDown( KEY_4 );
	}else{
		if( oldks.status & SKEY_X ) 
			pEng->m_pInput->KeyUp( KEY_4 );
	}

	// SKEY_SELECT - SELECT
	if( ks.status & SKEY_SELECT) {
		pEng->m_pInput->KeyDown( KEY_L1 );
	}else{
		if( oldks.status & SKEY_SELECT ) 
			pEng->m_pInput->KeyUp( KEY_L1 );
	}	
	
	//SKEY_START - START
	if( ks.status &  SKEY_START){
		pEng->m_pInput->KeyDown( KEY_R1 );
	}else{
		if( oldks.status & SKEY_START ) 
			pEng->m_pInput->KeyUp( KEY_R1 );
	}	

	//SKEY_L - L
	if( ks.status & SKEY_L ){
		pEng->m_pInput->KeyDown( KEY_L2 );
	}else{
		if( oldks.status & SKEY_L ) 
			pEng->m_pInput->KeyUp( KEY_L2 );
	}
	//SKEY_R - R
	if( ks.status &  SKEY_R){
		pEng->m_pInput->KeyDown( KEY_R2 );
	}else{
		if( oldks.status & SKEY_R ) 
			pEng->m_pInput->KeyUp( KEY_R2 );
	}



	//MAPPED
	//TODO: MAPEAR BOTONES	
	
	//SKEY_F3
	if( ks.status &  SKEY_F3){
		pEng->m_pInput->KeyDown( KEY_5 );
	}else{
		if( oldks.status & SKEY_F3 ) 
			pEng->m_pInput->KeyUp( KEY_5 );
	}

	//SKEY_E1
	if( ks.status &  SKEY_E1){
		pEng->m_pInput->KeyDown( KEY_6 );
	}else{
		if( oldks.status & SKEY_E1 ) 
			pEng->m_pInput->KeyUp( KEY_6 );
	}
	
	//SKEY_E2
	if( ks.status &  SKEY_E2){
		pEng->m_pInput->KeyDown( KEY_7 );
	}else{
		if( oldks.status & SKEY_E2 ) 
			pEng->m_pInput->KeyUp( KEY_7 );
	}
	//SKEY_E3
	if( ks.status &  SKEY_E3){
		pEng->m_pInput->KeyDown( KEY_8 );
	}else{
		if( oldks.status & SKEY_E3 ) 
			pEng->m_pInput->KeyUp( KEY_8 );
	}
		
	oldks = ks;
}


extern "C" int GameMain(char* respath)
{
	int ref = 1;
	int sysref = 0;
	GameEngine* pEng;
	Char AppFullName[256];
	char* fullpath;

	LOG_ON;
	  
	strcpy((Char16*)AppFullName, (Char16*)respath);

	fullpath = __to_locale_ansi( (wchar_t*)respath );
	GetPathFromFilename( g_FilePath, fullpath );

	// ޸Ļֱ
	int SCREEN_WIDTH = 320;
	int	SCREEN_HEIGHT = 240;

	void* userdata[5];
	
	userdata[0] = AppFullName;
	userdata[1] = g_FilePath;
	userdata[2] = fullpath;
	userdata[3] = (void*)&SCREEN_WIDTH;
	userdata[4] = (void*)&SCREEN_HEIGHT;

	pEng = new GameEngine( userdata );
	LOG(_LS("h"));
	pEng->Init();
	pEng->Start();

	g_bGameRuning = true;
	oldks.status = 0;
	 
	while( g_bGameRuning ){
		sysref = sys_judge_event( NULL);
		if( sysref  < 0 ){
			ref = sysref ;
			break;
		}
		onkey( pEng );

		pEng->OneFrame();
	}
	pEng->Stop();
	SAFE_DELETE( pEng );

	return ref;
}
